package AppGioco;

import java.util.*;
import AppGioco.Quadro.*;
import AppGioco.QuadroDedicato.*;

public final class TestGioco {
	private TestGioco() {
	}

	private static <E> String stampa(Collection<E> c) {
		String out = "";
		Iterator<E> it = c.iterator();
		while (it.hasNext())
			out = out + it.next() + "\n";
		return out;
	}

	private static String stampaPartita(Partita p) {
		return p.getCodice() + "\n" + stampa(p.getLinkGiocato());
	}

	public static void main(String[] args) {
		Quadro q1 = new Quadro("Sulla.spiaggia.amb");
		Quadro q2 = new Quadro("Nella.giungla.amb");
		Quadro q3 = new Quadro("Nella.caverna.amb");
		QuadroDedicato qq11 = new QuadroDedicato("Sulla.piattaforma.amb",
				"I.nemici.sfilano.mov");
		QuadroDedicato qq22 = new QuadroDedicato("Sull'.isola.amb",
				"Le.onde.si.fanno.minacciose.mov");
		QuadroDedicato qq33 = new QuadroDedicato("In.miniera.amb",
				"I.cristalli.brillano.mov");

		Personaggio p1 = new Personaggio("Il.capo.dei.nemici.jpg");
		Personaggio p2 = new Personaggio("Il.pesciolone.jpg");
//		Personaggio p3 = new Personaggio("Il.minatore.pazzo.jpg");
//		Personaggio p4 = new Personaggio("Il.robot.cattivo.jpg");
//		Personaggio p5 = new Personaggio("La.coniglietto.buono.jpg");

		Partita piero = new Partita("Parita.di.Piero");
		Partita elena = new Partita("Parita.di.Elena");

		p1.inserisciLinkPresente(qq11);
		p1.inserisciLinkPresente(q1);
		p2.inserisciLinkPresente(q1);
		p2.inserisciLinkPresente(qq22);

		System.out.println(stampa(p1.getLinkPresente()));

		ManagerDedicatoA.inserisci(new TipoLinkDedicatoA(qq11, p1));

		System.out.println(stampa(p1.getLinkDedicatoA()));

		ManagerGiocato.inserisci(new TipoLinkGiocato(q1, piero, 100));
		ManagerGiocato.inserisci(new TipoLinkGiocato(qq11, piero, 100));
		ManagerGiocato.inserisci(new TipoLinkGiocato(q2, piero, 100));
		ManagerGiocato.inserisci(new TipoLinkGiocato(q3, piero, 100));
		ManagerGiocato.inserisci(new TipoLinkGiocato(qq11, elena, 100));
		ManagerGiocato.inserisci(new TipoLinkGiocato(qq22, elena, 100));
		ManagerGiocato.inserisci(new TipoLinkGiocato(qq33, elena, 100));

		System.out.println(stampaPartita(piero));
		System.out.println(stampaPartita(elena));

		System.out.println(Controlli.quantePartite(qq11, 50));
		System.out.println(stampa(Controlli.partiteConPersonaggio(p1)));

		ManagerGiocato.elimina(new TipoLinkGiocato(qq11, elena, 100));
		ManagerGiocato.elimina(new TipoLinkGiocato(qq22, elena, 100));
		// AssociazioneGiocato.elimina(new TipoLinkGiocato(qq33,elena,100));

		System.out.println(stampaPartita(piero));
		System.out.println(stampaPartita(elena));

		System.out.println(Controlli.quantePartite(qq11, 50));
		System.out.println(stampa(Controlli.partiteConPersonaggio(p1)));
	}

}
